import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d.art3d import Poly3DCollection
import numpy as np

Ab = [0, 0, 0]
Bb = [1, 0, 0]
Cb = [1, 1, 0]
Db = [0, 1, 0]
At = [0, 0, 1]
Bt = [1, 0, 1]
Ct = [1, 1, 1]
Dt = [0, 1, 1]
#vert_names = ['Ab', 'Bb', 'Cb', 'Db', 'At', 'Bt', 'Ct', 'Dt']
#vertices = [Ab, Bb, Cb, Db, At, Bt, Ct, Dt]
vert_names = ['Ab', 'Bb', 'Cb', 'At', 'Bt', 'Ct']
vertices = [Ab, Bb, Cb, At, Bt, Ct]


def draw_tetrahedron(ax, T, color = 'black'):
    faces = [
        [T[0], T[1], T[2]],  # 面ABC
        [T[0], T[1], T[3]],  # 面ABD
        [T[0], T[2], T[3]],  # 面ACD
        [T[1], T[2], T[3]]   # 面BCD
        ]

    poly3d = Poly3DCollection(faces, alpha = .25, linewidths = 1, edgecolors = color)
    poly3d.set_facecolor(color)
    ax.add_collection3d(poly3d)


fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')

for i, vertex in enumerate(vertices):
    ax.scatter(*vertex, color = 'black')
    ax.text(*vertex, vert_names[i], size = 12, zorder = 1, color = 'black')

draw_tetrahedron(ax, [Ab, Bb, Cb, At], 'darkgreen')
draw_tetrahedron(ax, [At, Bt, Ct, Bb], 'blue')
draw_tetrahedron(ax, [At, Ct, Bb, Cb], 'red')

ax.set_xlabel('X')
ax.set_ylabel('Y')
ax.set_zlabel('Z')

ax.set_box_aspect([1,1,1])  # Aspect ratio is 1:1:1

plt.show()